#include <bits/stdc++.h>
using namespace std;
using ll = long long;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    int n;
    if (!(cin >> n)) return 0;
    vector<ll> xs(n), ys(n);
    for (int i = 0; i < n; ++i) cin >> xs[i] >> ys[i];

    // maps: y -> (cnt_x_even, cnt_x_odd)
    unordered_map<ll, pair<ll,ll>> byY;
    // x -> (cnt_y_even, cnt_y_odd)
    unordered_map<ll, pair<ll,ll>> byX;
    // S = x+y -> count
    unordered_map<ll, ll> byS;
    // D = x-y -> count
    unordered_map<ll, ll> byD;

    byY.reserve(n * 2);
    byX.reserve(n * 2);
    byS.reserve(n * 2);
    byD.reserve(n * 2);

    for (int i = 0; i < n; ++i) {
        ll x = xs[i], y = ys[i];
        int px = (int)(x & 1LL); // parity of x (works for negatives)
        int py = (int)(y & 1LL);
        auto &pY = byY[y];
        if (px == 0) ++pY.first; else ++pY.second;
        auto &pX = byX[x];
        if (py == 0) ++pX.first; else ++pX.second;
        byS[x + y] += 1;
        byD[x - y] += 1;
    }

    long long ans = 0;

    // north-south on same y: pairs with same parity of x
    for (auto &kv : byY) {
        ll even = kv.second.first;
        ll odd  = kv.second.second;
        if (even >= 2) ans += (even * (even - 1)) / 2;
        if (odd  >= 2) ans += (odd  * (odd  - 1)) / 2;
    }

    // east-west on same x: pairs with same parity of y
    for (auto &kv : byX) {
        ll even = kv.second.first;
        ll odd  = kv.second.second;
        if (even >= 2) ans += (even * (even - 1)) / 2;
        if (odd  >= 2) ans += (odd  * (odd  - 1)) / 2;
    }

    // pairs with same S: each unordered pair gives 2 greetings -> contribute cnt*(cnt-1)
    for (auto &kv : byS) {
        ll c = kv.second;
        if (c >= 2) ans += c * (c - 1); // equals 2 * C(c,2)
    }

    // pairs with same D: each unordered pair gives 2 greetings
    for (auto &kv : byD) {
        ll c = kv.second;
        if (c >= 2) ans += c * (c - 1);
    }

    cout << ans << '\n';
    return 0;
}